
////////////////////////////////////////////////////////////
//	File:		"CHighScoreState.h"
//	Author:		[AK] Andrew Kryvanis
//	Modified:	[AK] August 05, 2008
//	Purpose:	Defines the high score game state.
//				- Singleton
////////////////////////////////////////////////////////////

#ifndef CHIGHSCORESTATE_H_
#define CHIGHSCORESTATE_H_

#include "IGameState.h"

class CSGD_TextureManager;
class CSGD_DirectInput;
class CGame;

#include <string>			// For the initials.

class CHighScoreState : public IGameState
{

public:

	/* Public Data Members */

protected:

private:
	static CHighScoreState				sm_Instance;		//	The instance of the high score state
	CSGD_TextureManager*				m_pTM;				// Texture Manager
	CSGD_DirectInput*					m_pDI;				// Direct Input
	CGame*								m_pGame;			// Game

	int									m_nScore;			//
	int									m_nBGImage;			// Background Image ID.
	int									m_nMusicID;			//	The background music sound ID.
	std::string							m_szScores[10];		// Top 10 initials.
	int									m_nScores[10];		// Top 10 scores.
	char								m_szInput[4];		// User initials input.

	bool								m_bInputScore;		// Is the user required to input initials upon entering this state?

	/* Disabled Functions */
	CHighScoreState(const CHighScoreState& C);
	CHighScoreState& operator=(const CHighScoreState& C);

public:

	////////////////////////////////////////////////////////////
	//	Function:	Accessors
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Gets the specified type.
	////////////////////////////////////////////////////////////
	bool GetInputScore() const { return m_bInputScore; }

	////////////////////////////////////////////////////////////
	//	Function:	Mutators
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Sets the specified type.
	////////////////////////////////////////////////////////////
	void SetInputScore(bool bInputScore) { m_bInputScore = bInputScore; }
	void SetInitials(char* szInitials);
	void SetScore(int nScore) { m_nScore = nScore; }

	////////////////////////////////////////////////////////////
	//	Function:	GetInstance
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Returns the singleton's instance.
	////////////////////////////////////////////////////////////
	static CHighScoreState* GetInstance();

	////////////////////////////////////////////////////////////
	//	Function:	Enter (Overloaded)
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Enters into the game state.
	////////////////////////////////////////////////////////////
	virtual void Enter();

	////////////////////////////////////////////////////////////
	//	Function:	Input (Overloaded)
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Receives input for the game state.
	////////////////////////////////////////////////////////////
	virtual bool Input(float fElapsedTime);

	////////////////////////////////////////////////////////////
	//	Function:	Update (Overloaded)
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Updates the game state.
	////////////////////////////////////////////////////////////
	virtual void Update(float fElapsedTime);

	////////////////////////////////////////////////////////////
	//	Function:	Render (Overloaded)
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Draws the game state to the screen.
	////////////////////////////////////////////////////////////
	virtual void Render();
	
	////////////////////////////////////////////////////////////
	//	Function:	Exit (Overloaded)
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Exits out of the game state.
	////////////////////////////////////////////////////////////
	virtual void Exit();

	////////////////////////////////////////////////////////////
	//	Function:	CheckScore
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Checks if a specific score can beat any
	//				 existing high scores.
	////////////////////////////////////////////////////////////
	bool CheckScore(int nScore);

	////////////////////////////////////////////////////////////
	//	Function:	ReadFile
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Reads the high scores from the database
	//				 file.
	////////////////////////////////////////////////////////////
	void ReadFile();

	////////////////////////////////////////////////////////////
	//	Function:	WriteFile
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Writes the high scores to the database
	//				 file.
	////////////////////////////////////////////////////////////
	void WriteFile();

	////////////////////////////////////////////////////////////
	//	Function:	PushScore
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Adds a specific score to the list- if it
	//				 can beat any existing high scores.
	//				Returns false if was not pushed.
	////////////////////////////////////////////////////////////
	bool PushScore(int nScore);

protected:

	/* Protected Functions */

private:

	/* Private Functions */

	////////////////////////////////////////////////////////////
	//	Function:	Constructor
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Initializes the object.
	////////////////////////////////////////////////////////////
	CHighScoreState();

	////////////////////////////////////////////////////////////
	//	Function:	Destructor
	//	Modified:	[AK] August 05, 2008
	//	Purpose:	Deallocates the object.
	////////////////////////////////////////////////////////////
	virtual ~CHighScoreState();

};

#endif
